'use strict';

angular.module('rounds_model', ['configuration_model'])
    .factory('Round', ['$http', function($http){
        function Round(roundData){
            this.setData(roundData);
        }

        Round.prototype = {
            isStarted: function(){
                var d = new Date();
                var curr_date = d.getDate();
                curr_date = (curr_date < 10) ? '0' + curr_date : curr_date;
                var curr_month = d.getMonth() + 1; //Months are zero based
                curr_month = (curr_month < 10) ? '0' + curr_month : curr_month;
                var curr_year = d.getFullYear();
                var curr_hour = d.getHours();
                curr_hour = (curr_hour < 10) ? '0' + curr_hour : curr_hour;
                var curr_minutes = d.getMinutes();
                curr_minutes = (curr_minutes < 10) ? '0' + curr_minutes : curr_minutes;
                var curr_seconds = d.getSeconds();
                curr_seconds = (curr_seconds < 10) ? '0' + curr_seconds : curr_seconds;

                return this.start_at <= curr_year + "-" + curr_month + "-" + curr_date + ' ' + curr_hour + ':' + curr_minutes + ':' + curr_seconds;
            }
            ,setData: function(roundData){
                angular.extend(this, roundData);
            }
        }

        return Round;
    }])
    .factory('RoundsManager', ['$http', '$q', 'Round', 'Configuration', function($http, $q, Round, Configuration){
        var roundsManager = {
            _loadedAllData: false
            ,_rounds: []
            ,_getPreviousRound: function(round){
                var index = this._rounds.indexOf(round);
                return (index > 0) ? this._rounds[--index] : false;
            }
            ,_getNextRound: function(round){
                var index = this._rounds.indexOf(round);
                return (index < this._rounds.length - 1) ? this._rounds[++index] : false;
            }
            ,_isFirst: function(round){
                return this._rounds.indexOf(round) === 0;
            }
            ,_isLast: function(round){
                return this._rounds.indexOf(round) === this._rounds.length - 1;
            }
            ,loadData: function(){
                if(this._loadedAllData)
                {
                    return this._rounds;
                }
                var deferred = $q.defer();
                var scope = this;
                $http.get(Configuration.urlRounds)
                    .success(function(roundsArray){
                        roundsArray.forEach(function(roundData){
                            scope._rounds.push(new Round(roundData));
                        });

                        scope._loadedAllData = true;
                        deferred.resolve(scope._rounds);
                    })
                    .error(function(){
                        deferred.reject();
                    });
                return deferred.promise;
            }

            ,isEndedRound: function(Round){
                var PrevRound = this._getPreviousRound(Round);
                if(PrevRound !== false && !PrevRound.is_done)
                {
                    return false;
                }

                var NextRound = this._getNextRound(Round);
                if(NextRound == false)
                {
                    return true;
                }
                else
                {
                    if(!NextRound.isStarted())
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
            }

            ,validateRounds: function(){
                var countWrongs = 0;
                this._rounds.forEach(function(round){                    
                    if(!this._isLast(round))
                    {
                        var nextRound = this._getNextRound(round);
                        if(!nextRound.isEmptyStartDate() && round.start_at >= nextRound.start_at)
                        {
                            nextRound.setWrong(true);
                            countWrongs++;
                        }
                    }
                    else
                    {
                        var prevRound = this._getPreviousRound(round);
                        if(!round.isEmptyStartDate() && prevRound.start_at >= round.start_at)
                        {
                            round.setWrong(true);
                            countWrongs++;
                        }
                    }

                    if(!this._isFirst(round) && !this._isLast(round))
                    {
                        var prevRound = this._getPreviousRound(round);
                        if(prevRound.isEmptyStartDate() && !round.isEmptyStartDate())
                        {
                            round.setWrong(true);
                            countWrongs++;
                        }
                    }

                }, this);

                return (countWrongs == 0);
            }
            ,setAllRoundsAsCorrect: function(){
                this._rounds.forEach(function(round){
                    round.setWrong(false);
                });
            }
            ,getRound: function(roundId){
                var Round = false;
                for(var i = 0; i < this._rounds.length; i++)
                {
                    if(this._rounds[i].id == roundId)
                    {
                        Round = this._rounds[i];
                        break;
                    }
                }
                return Round;
            }
            ,getRoundSequence: function(roundId){
                var Round = this.getRound(roundId);
                return (Round !== false) ? Round.sequence : 0;
            }
        }

        return roundsManager;
    }])

;